package w83b.w83bOperacionesPaso.w83bComunicaciones;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bComunicacionesBean;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;

import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

public class W83bGenerarTxtExtracDatosAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
		ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
		
		List lista = (ArrayList)contexto.get("w83bResultadoBean");
		
		BufferedWriter bw;
		
		File fichero = new File("ExtraccionDatos.txt");
        fichero.createNewFile();
        bw = new BufferedWriter(new FileWriter(fichero.getAbsolutePath()));
        
        StringBuffer linea = new StringBuffer();
        
        for (int i=0; i<lista.size()-1;i++){
        	W83bComunicacionesBean comunic=(W83bComunicacionesBean)lista.get(i);
        	if (comunic.getNlaudo()==null){
        		linea.append("000");
            	linea.append(";");
            	linea.append("0000");
            	linea.append(";");
            	linea.append("00000000");
            	linea.append(";");
        	}
        	else{
        		linea.append(W83bUtilidades.rellenarCaracter(comunic.getNlaudo(), "0", 3, true));
            	linea.append(";");
            	linea.append(comunic.getAnolaudo());
            	linea.append(";");
            	linea.append(comunic.getFlaudo().replaceAll("/", ""));
            	linea.append(";");
        	}
        	linea.append(W83bUtilidades.rellenarCaracter(comunic.getNimpug(), "0", 6, true));
        	linea.append(";");
        	linea.append(comunic.getAnoimpug());
        	linea.append(";");
        	if (W83bClsConstantes.UNO==Integer.parseInt(comunic.getOrderby())){
        		linea.append(W83bUtilidades.rellenarCaracter(comunic.getNacta(), "0", 6, true));
            	linea.append(";");
            	linea.append(comunic.getAnoacta());
            	linea.append(";");
            	linea.append("000000");
            	linea.append(";");
            	linea.append("0000");
            	linea.append(";");
        	}
        	else{
        		linea.append("000000");
            	linea.append(";");
            	linea.append("0000");
            	linea.append(";");
        		linea.append(W83bUtilidades.rellenarCaracter(comunic.getNacta(), "0", 6, true));
            	linea.append(";");
            	linea.append(comunic.getAnoacta());
            	linea.append(";");
        	}
        	if (comunic.getArbitro()!=null){
        		linea.append(comunic.getArbitro());
        	}
        	else{
        		linea.append("");
        	}
        	linea.append(";");
        	if (comunic.getSindicatos()!=null){
        		String sind[]=comunic.getSindicatos().split("\\?");
            	for (int j=0;j<sind.length;j++){
            		String s[]=sind[j].split("\\|");
            		linea.append(W83bUtilidades.rellenarCaracter(s[0], "0", 3, true));
            		linea.append("|");
	            	linea.append(s[1]);
	            	if (j==sind.length-1){
            			linea.append(";");
            		}
            		else{
            			linea.append("$");
            		}
            	}
            	
        	}
        	else{
        		linea.append(";");
        	}
        	linea.append(comunic.getRazon());
        	linea.append(";");
        	linea.append(comunic.getCif());
        	linea.append(";");
        	if (comunic.getVoces()!=null){
        		String voz[]=comunic.getVoces().split("\\?");
            	for (int j=0;j<voz.length;j++){
            		String v[]=voz[j].split("\\|");
            		if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
            			linea.append(v[3]);
                    	linea.append("|");
            		}
            		else{
            			linea.append(v[4]);
                    	linea.append("|");
            		}
            		if (W83bClsConstantes.UNO==Integer.parseInt(v[2])){
            			linea.append(W83bClsConstantes.CONSTANTE_SI);
            		}
            		else{
            			linea.append(W83bClsConstantes.CONSTANTE_NO);
            		}
            		if (j==voz.length-1){
        				linea.append(";");
        			}
        			else{
        				linea.append("$");
        			}
            	}
        	}
        	else{
        		linea.append(";");
        	}
        	linea.append("\r\n");
        }
        
        bw.write(linea.toString());
        
        bw.flush();
        bw.close();
	            
        BufferedOutputStream out = new BufferedOutputStream(response.getOutputStream());      
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(fichero));
       
        response.setContentType("text/plain");
        response.setHeader("Content-Disposition","attachment;filename=ExtraccionDatos.txt");
        int c;
        while ((c = in.read()) != -1){
            out.write(c);
        }
        in.close();
        out.flush();
        out.close();
		
		return null;

	}
	
}

